// ===========================================================================
//	LSimpleThread.cp			PowerPlant 2.2.1	1994-1999 Metrowerks Inc.
// ===========================================================================
//	Original Author: Paul Lalonde

#ifdef PowerPlant_PCH
	#include PowerPlant_PCH
#endif

#include <LSimpleThread.h>

PP_Begin_Namespace_PowerPlant


// ---------------------------------------------------------------------------
//	 LSimpleThread							Constructor				  [public]
// ---------------------------------------------------------------------------

LSimpleThread::LSimpleThread(
	ThreadProc				proc,
	void					*arg,
	Boolean					preempt,
	UInt32					stack,
	LThread::EThreadOption	flags)

	: LThread(preempt, stack, flags)
{
	THREAD_ASSERT(proc != NULL);

	mProc	= proc;
	mArg	= arg;
}


// ---------------------------------------------------------------------------
//	 Run
// ---------------------------------------------------------------------------
//	Execute the code for this thread.

void	*LSimpleThread::Run()
{
	(*mProc)(*this, mArg);

	return mResult;
}


PP_End_Namespace_PowerPlant
